/*
 * (c) Copyright 2000 -- Anders Torger
 *
 * This software is free. You can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation.
 *
 */
#ifndef ALSAIO_H_
#define ALSAIO_H_

#include "defs.h"
#include "sample.h"

bool_t
alsaio_getfragsize(int card,
		   int device,
		   bool_t is_input,
		   int *min_fragsize,
		   int *max_fragsize,
		   int *buffersize);

bool_t
alsaio_init_output(int fragsize,
		   int card,
		   int device,
		   int n_channels,
		   int rate,
		   struct sample_format *sf);

bool_t
alsaio_init_input(int fragsize,
		  int n_frags,
		  int card,
		  int device,
		  int n_channels,
		  int rate,
		  struct sample_format *sf);

void
alsaio_output(void *buf,
	      int size);

int
alsaio_input(void *buf);

void
alsaio_stop(void);

#endif
