/*
 * (c) Copyright 1999 -- Anders Torger
 *
 * This software is free. You can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation.
 *
 */
#ifndef COEFFS_H_
#define COEFFS_H_

#include <stdio.h>
#include <sys/types.h>

#include "defs.h"

double **
coeffs_parse(int *len,
	     FILE *stream);

int32_t *
coeffs_requantisise(double coeffs[],
		    int len,
		    int bits,
		    int32_t *multiplier,
		    double *error);

void
coeffs_free(double *coeffs[]);

bool_t
coeffs_print(FILE *stream,
	     double *coeffs[],
	     int len,
	     bool_t raw);

double
coeffs_fractionparse(char *s);

#endif
