#ifndef FDRW_H_
#define FDRW_H_

#include <unistd.h>
#include <errno.h>

#include "defs.h"

static inline bool_t
readfd(int fd,
       void *buf,
       size_t count)
{
    int n, i = 0;

    do {
	if ((n = read(fd, buf + i, count - i)) < 1) {
	    if (n == 0 || errno != EINTR) {
		return false;
	    }
	    continue;
	}
	i += n;
    } while (i != count);
    return true;
}

static inline bool_t
writefd(int fd,
	void *buf,
	size_t count)
{
    int n, i = 0;

    do {
	if ((n = write(fd, buf + i, count - i)) < 1) {
	    if (n == 0 || errno != EINTR) {
		return false;
	    }
	    continue;
	}
	i += n;
    } while (i != count);
    return true;
}

#endif
