/*
 * (c) Copyright 2000 -- Anders Torger
 *
 * This software is free. You can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation.
 *
 */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "defs.h"
#include "sample.h"

bool_t
sample_parse_format(struct sample_format *sf,
		    char *s)
{
    int16_t test = 0xFF00;
    
    if (strlen(s) < 6) {
	fprintf(stderr, "parse_sample_format: Invalid sample format string "
		"\"%s\" (string is too short)\n", s);
	return false;
    }
    sf->is_signed = (strchr(s, 's') != NULL);
    sf->is_little_endian = (strchr(s, 'l') != NULL);
    if (((uint8_t *)&test)[0] == 0) {
	sf->swap = !sf->is_little_endian;
    } else {
	sf->swap = sf->is_little_endian;
    }
    sf->bits = atoi(s);
    sf->bytes = atoi(&s[3]);
    sf->left_shift = atoi(&s[5]);
    sf->shift = 32 - sf->bits - sf->left_shift;

    if (sf->bits < 16 || sf->bits > 32) {
	fprintf(stderr, "parse_sample_format: Invalid sample format string: "
		"bits must be 16 - 32\n");
	return false;
    }
    if (sf->bytes < 2 || sf->bytes > 4) {
	fprintf(stderr, "parse_sample_format: Invalid sample format string: "
		"bytes must be 2 - 4\n");
	return false;
    }
    if (sf->left_shift < 0 || sf->left_shift > 16) {
	fprintf(stderr, "parse_sample_format: Invalid sample format string: "
		"shift must be 0 - 16\n");
	return false;
    }
    if (sf->bytes * 8 < sf->bits + sf->left_shift) {
	fprintf(stderr, "parse_sample_format: Invalid sample format string: "
		"sample does not fit into the given space\n");
	return false;
    }    
    return true;
}
