/*
 * (c) Copyright 1999 -- Anders Torger
 *
 * This software is free. You can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation.
 *
 */
#ifndef SPLINE_H_
#define SPLINE_H_

#include "defs.h"

bool_t
linear(double y_out[],
       double x_new[],
       double x[],
       double y[],
       int len,
       int len_new);

bool_t
spline(double y_out[], /* Will receive the interpolated y coordinates. It is
			* possible to have y_out the same as x_new. */
       double x_new[], /* Sorted x coordinates for the interpolated y
			* coordinates. Distinct values in ascending
			* order */
       double x[],     /* Sorted x coordinates, distinct values in ascending
		        * order. */
       double y[],     /* Corresponding y coordinates. */
       int len,        /* Length of x and y arrays. */
       int len_new);   /* Length of x_new and y_out arrays. */


#endif
