/*
 * (c) Copyright 2000 -- Anders Torger
 *
 * This software is free. You can redistribute it and/or modify it under the
 * terms of the GNU Public License as published by the Free Software Foundation.
 *
 */
#ifndef TIMESTAMP_H_
#define TIMESTAMP_H_

#include <inttypes.h>

static inline void
timestamp(uint64_t *ts)
{
    asm volatile (
	"rdtsc            \n\t"
	"movl  %%eax, %0  \n\t"
	"movl  %%edx, %1  \n\t"
	: "=g" (((uint32_t *)ts)[0]),
	"=g" (((uint32_t *)ts)[1])
	:: "eax", "edx");
}

#endif
