/*
 * (c) Copyright 1999, 2000 -- Anders Torger
 *
 * This software is free. You can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation.
 *
 */
#ifndef TOOLBOX_H_
#define TOOLBOX_H_

#include <gsl/gsl_complex.h>
#include "defs.h"

double *
tb_log2lengthen(int *len,
		double signal[]);

void
tb_dbconvert(double signal[],
	     int len,
	     bool_t to_db);

void
tb_degreeconvert(double signal[],
		 int len,
		 bool_t to_degrees);

int
tb_getlog2(int x);

void
tb_abs_on_halfcomplex(double signal[],
		      int len);

void
tb_halfcomplex2complex(gsl_complex_packed_array complex,
		       double halfcomplex[],		       
		       int len);

double *
tb_interpolate(double **x_new,
	       double x[],
	       double y[],
	       int len,
	       int newlen,
	       bool_t set_endpoints,
	       double first_x,
	       double last_x,
	       double first_y,
	       double last_y);

double *
tb_splinewarp(double signal[],
	      int len,
	      double warp_factor,
	      double sfreq);

double *
tb_linearwarp(double signal[],
	      int len,
	      double warp_factor,
	      double sfreq);

bool_t
tb_real_cepstrum(double rc[],
		 double ep[],
		 double mp[],
		 gsl_complex_packed_array signal,
		 int len);

gsl_complex_packed_array
tb_hilbert(double x[],
	   int len);

bool_t
tb_hilbert_phase_split(double ep[],
		       double mp[],
		       double x[],
		       int len);

double *
tb_levinson(double x[],
	    int len,
	    double y[],
	    int order);

double *
tb_levinson_durbin(double x[],
		   int len,
		   int order);

double *
tb_cross_correlation(double x[],
		     int len);

double *
tb_linear_predictor_coefficients(double signal[],
				 int len,
				 int order);

#endif
