/*
 * (c) Copyright 1999 -- Anders Torger
 *
 * This software is free. You can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation.
 *
 */
#ifndef WFIR_H_
#define WFIR_H_

#include <sys/types.h>

#include "defs.h"
#include "filter.h"

filterproc_t *
wfir_new(char coeffs_filename[],
	 double warp_factor,
	 double gain,
	 int *taps,
	 double *coeffs_error);

/* the default assembler implemented wfir loop, with warp factor 127/128 */
int64_t
wfir_process_asm127(int32_t sample,
		    int32_t coeffs[],
		    int taps,
		    int32_t state[]);

/* same loop with other warp factors, 1/2, 3/4, 7/8 etc */
int64_t wfir_process_asm1(int32_t x, int32_t c[], int t, int32_t s[]);
int64_t wfir_process_asm3(int32_t x, int32_t c[], int t, int32_t s[]);
int64_t wfir_process_asm7(int32_t x, int32_t c[], int t, int32_t s[]);
int64_t wfir_process_asm15(int32_t x, int32_t c[], int t, int32_t s[]);
int64_t wfir_process_asm31(int32_t x, int32_t c[], int t, int32_t s[]);
int64_t wfir_process_asm63(int32_t x, int32_t c[], int t, int32_t s[]);
int64_t wfir_process_asm255(int32_t x, int32_t c[], int t, int32_t s[]);

int64_t
wfir_process_int(int32_t sample,
		 int32_t coeffs[],
		 int taps,
		 int32_t state[]);

double
wfir_process_real(double sample,
		  double coeffs[],
		  int taps,
		  double state[],
		  double warp_factor);

#endif
